<?php
$lang['admindescription'] = 'Un éditeur WYSIWYG complet et personnalisable';
$lang['advanced_menu'] = 'Menu avancé';
$lang['apply'] = 'Appliquer';
$lang['autoresize'] = 'Redimensionnement automatique';
$lang['block_formats'] = 'Formats disponibles';
$lang['button_name'] = 'Nom du bouton';
$lang['cancel'] = 'Annuler';
$lang['cmsms_linker'] = 'Lien vers une page de contenu';
$lang['contextmenu'] = 'Menu contextuel';
$lang['contextmenu_content'] = 'Contenu du menu contextuel';
$lang['copy'] = 'copier';
$lang['copy_profile'] = 'Dupliquer le profil';
$lang['css_classes'] = 'Classes CSS';
$lang['custom_dropdown'] = 'Menu personnalisé';
$lang['custom_dropdown_title'] = 'Titre du menu personnalisé';
$lang['default'] = 'Défaut';
$lang['default_designmanager_template'] = 'Gabarit par défaut du module de gestion du design';
$lang['default_profile_set'] = 'Profil par défaut modifié';
$lang['delete_profile'] = 'Supprimer le profil';
$lang['delete_profile_confirm'] = 'Êtes-vous sûr de vouloir supprimer ce profil ?';
$lang['design_css'] = 'Design à utiliser pour les feuilles de styles';
$lang['documentation'] = 'Documentation&nbsp;';
$lang['edit_profile'] = 'Modifier le profil';
$lang['enable_contextmenu'] = 'Activer le menu contextuel (clic droit)';
$lang['enable_custom_dropdown'] = 'Activer le menu personnalisé';
$lang['enable_linker'] = 'Charger le plugin de liens internes';
$lang['enable_user_templates'] = 'Activer les gabarits utilisateurs';
$lang['error_delete_profile'] = 'Une erreur est survenue lors de la suppression du profil';
$lang['error_cannot_delete_default_profile'] = 'Erreur : le profil par défaut ne peut pas être supprimé';
$lang['error_saving_profile'] = 'Une erreur est survenue pendant le processus de sauvegarde';
$lang['external_modules'] = 'Modules externes';
$lang['external_modules_show_menutext'] = 'Afficher le titre du bouton dans la barre d\'outils - décoché = icône seule';
$lang['extra_js'] = 'Code javascript supplémentaire (appelé dans le script <em>init()</em>)';
$lang['filemanager'] = 'Gestionnaire de fichiers';
$lang['filemanager_aviary_active'] = 'Activer l\'éditeur d\'images Aviary';
$lang['filemanager_aviary_apiKey'] = 'Clé API Aviary';
$lang['filemanager_chmod_dirs'] = 'CHMOD dossiers';
$lang['filemanager_chmod_files'] = 'CHMOD fichiers';
$lang['filemanager_copy_cut_dirs'] = 'Couper et copier des dossiers';
$lang['filemanager_copy_cut_files'] = 'Couper et copier des fichiers';
$lang['filemanager_create_folders'] = 'Créer des dossiers';
$lang['filemanager_create_text_files'] = 'Créer des fichiers texte';
$lang['filemanager_delete_files'] = 'Supprimer des fichiers';
$lang['filemanager_delete_folders'] = 'Supprimer des dossiers';
$lang['filemanager_duplicate_files'] = 'Dupliquer des fichiers';
$lang['filemanager_edit_text_files'] = 'Editer les fichiers texte';
$lang['filemanager_image_resizing'] = 'Redimensionner automatiquement les images après téléversement';
$lang['filemanager_image_resizing_title'] = 'Redimensionnement automatique des images';
$lang['filemanager_image_resizing_height'] = 'Hauteur max des images après redimensionnement';
$lang['filemanager_image_resizing_width'] = 'Largeur max des images après redimensionnement';
$lang['filemanager_photo_editor'] = 'Editeur photo Aviary';
$lang['filemanager_preview_text_files'] = 'Prévisualisation des fichiers texte';
$lang['filemanager_rename_files'] = 'Renommer les fichiers';
$lang['filemanager_rename_folders'] = 'Renommer les dossiers';
$lang['filemanager_upload_files'] = 'Téléverser des fichiers';
$lang['filemanager_options'] = 'Options du gestionnaire de fichiers';
$lang['filemanager_use'] = 'Activer le gestionnaire de fichiers';
$lang['friendlyname'] = 'Editeur WYSIWYG TinyMCE';
$lang['forced_root_block'] = 'Forcer le saut de ligne du paragraphe';
$lang['general'] = 'Général';
$lang['global_settings'] = 'Paramètres globaux';
$lang['group_frontend'] = 'Utilisateur du site';
$lang['help_advanced_menu'] = 'Vous pouvez activer cette option si vous souhaitez aller plus loin dans la personnalisation du menu. Modifiez le menu grâce au champ fourni. L\'activation de cette option désactivera le menu par défaut';
$lang['help_autoresize'] = 'Active le plugin <em>autoresize</em> permettant à l\'éditeur de modifier sa hauteur en fonction du contenu';
$lang['help_aviary'] = 'L\'éditeur Aviary est un éditeur d\'images externe fourni par Adobe.';
$lang['help_design_css'] = 'TinyMCE peut charger un jeu de feuilles de styles attachées à un design (via le Gestionnaire du design) afin d\'améliorer le rendu graphique.<br><br>Dans le gabarit javascript par défaut, ce paramètre est ignoré si la balise {content} qui gère les blocs comprend un paramètre <em>cssname</em>. Ce comportement peut être modifié avec un gabarit javascript sur mesure.<br><br><strong>Important :</strong> si vous utilisez cette fonction, vous devrez vider le cache du CMS après chaque changement sur les feuilles de styles associées.';
$lang['help_enable_custom_dropdown'] = 'Ajoute un menu sur mesure permettant l\'ajout de petits morceaux de codes au contenu. N\'oubliez pas d\'ajouter le bouton <em><strong>customdropdown</strong></em> à la barre d\'outils si vous souhaitez qu\'il y apparaisse. Le menu <em>Insérer</em> l\'affichera dans tous les cas';
$lang['help_external_modules'] = 'Certains modules CMS Made Simple peuvent générer un menu pour l\'éditeur TinyMCE. Merci de sélectionner quels modules externes doivent être chargés. N\'oubliez pas d\'ajouter le bouton associé au module dans la bare d\'outils. Le menu <em>Insérer</em> affichera également le menu.';
$lang['help_extra_js'] = 'Vous pouvez insérer du code javascript pour la configuration de TinyMCE. Merci de séparer chaque entrée avec une virgule. Consultez la documentation de TinyMCE pour en savoir plus.';
$lang['help_filemanager_image_resizing'] = 'Après le téléversement d\'une image, le gestionnaire de fichiers peut automatiquement la redimensionner aux dimensions maximales indiquées. Utile pour éviter de conserver des images trop grandes et lourdes dans les pages.';
$lang['help_filemanager_use'] = 'Activer le gestionnaire de fichiers - Notez que pour raison de sécurité, le gestionnaire de fichiers ne sera jamais chargé hors de l\'administration<br><br>Le gestionnaire de fichiers sera inclus dans les boites de dialogue <em>Insérer un lien</em> et <em>Insérer une image</em>, mais vous pouvez également ajouter le bouton <em>responsivefilemanager</em> à votre barre d\'outils pour un accès direct.';
$lang['help_forced_root_block'] = 'Cette option vous permet de vous assurer que le texte ou les éléments non-blocs soient toujours inclus dans une balise <p>. Par exemple, <strong>texte</strong> sera traduit en <p><strong>texte</strong></p>.<br><br>Si cette option est décochée, l\'éditeur n\'ajoutera jamais de balise <strong><p></strong> lors d\'un saut de ligne, seulement <strong><br></strong>. Vous devrez alors utiliser la combinaison Shift+Entrée pour produire une balise <strong><p></strong>.';
$lang['help_image_classes'] = 'Indiquez quelles classes CSS les utilisateurs pourront appliquer à une image. S\'il le souhaite, l\'utilisateur pourra choisir la classe lors de l\'ajout/édition d\'une image.';
$lang['help_link_classes'] = 'Indiquez quelles classes CSS les utilisateurs pourront appliquer à un lien. S\'il le souhaite, l\'utilisateur pourra choisir la classe lors de l\'ajout/édition d\'un lien.';
$lang['help_js_template'] = 'Le module TinyMCE peut utiliser un gabarit javascript sur mesure. De cette manière, vous pouvez totalement adapter le comportement de TinyMCE à vos besoins.<br><br>Si vous souhaitez utiliser le fichier fourni avec le module, choisissez <em>Gabarit original fourni avec le module</em>.<br><br>Si vous êtes développeur, vous pouvez choisir d\'utiliser un gabarit issu du gestionnaire de design. Soyez conscients cependant du fait que vous devrez probablement mettre à jour votre fichier à chaque nouvelle version du module TinyMCE.';
$lang['help_menubar'] = 'Indiquez les entrées de menu à afficher. Consultez la documentation pour en savoir plus.';
$lang['help_plugins'] = 'TinyMCE inclus un certain nombre de <em>plugins</em> afin d\'étendre ses possibilités. Avant d\'ajouter un bouton à la barre d\'outils ou au menu, vous devrez probalement l\'ajouter ici. Notez que les plugins <em>cmsms_linker</em>, <em>template</em>, <em>contextmenu</em> et <em>responsivefilemanager</em> sont chargés automatiquement.<br>Consultez la documentation pour avoir la liste complète des plugins disponibles.';
$lang['help_priority'] = 'Ce paramètre est utilisé pour déterminer quel profil doit être chargé en priorité quand un utilisateur est rattaché à plusieurs groupes correspondant à plusieurs profils TinyMCE. Le nombre le plus petit a la priorité la plus élevée.<br><br>Exemple : l\'utilisateur 1 est rattaché aux groupes A et C. Le groupe A a le profil TinyMCE Y, le C le Z. Le profil que l\'utilisateur verra s\'afficher sera celui qui a la priorité la plus basse entre Y et Z.';
$lang['help_relative_urls'] = 'Si cette option est cochée, toutes les URLs d\'images/liens seront définies relativement à l\'url principale du site (exemple : <em>/uploads/images/mon-image.jpg</em>).<br><br>Si décochée, les urls des images et liens seront définies de manière absolue dans le code source (exemple : <em>http://www.mon-site.com/uploads/images/mon-image.jpg</em>).';
$lang['help_show_statusbar'] = 'Afficher ou masquer la barre de statut. L\'activation de l\'option de redimensionnement affichera cette barre dans tous les cas';
$lang['help_style_formats'] = 'Les utilisateurs peuvent insérer des balises pré-formatées avec un menu <em>Formats</em>. Vous pouvez ici choisir quels styles seront disponibles dans ce menu. Notez que dans le cas des classes, vous devrez ajouter les règles CSS dans les feuilles de styles appropriées si vous souhaitez un rendu graphique différent. Consultez la documentation pour en savoir plus.<br><br>N\'oubliez pas d\'ajouter le bouton <em>styleselect</em> à la barre d\'outils si vous le souhaitez.';
$lang['help_toolbar'] = 'Indiquez quels boutons afficher dans la barre d\'outils sous forme d\'icônes. N\'oubliez pas de charger les plugins appropriés si besoin.';
$lang['help_use_custom_block_formats'] = 'Sélectionnez les formats que les utilisateurs pourront sélectionner. Cette option ne fonctionne qu\'avec le bouton <em>formatselect</em> et pour les éléments de type bloc (h1...6, div, prev, ...)';
$lang['help_user_templates'] = 'Les gabarits utilisateur sont des gabarits HTML que l\'utilisateur peut inclure dans le contenu grâce au plugin <em>template</em>. Vous pouvez créer autant de gabarits que nécessaire dans le gestionnaire de design du CMS (type du gabarit : Gabarit utilisateur TinyMCE).<br><br>Une fois cette option activée, vous pouvez ajouter le bouton <em>template</em> à votre barre d\'outils. Il sera également automatiquement ajouté à la barre de menu.';
$lang['help_usergroups'] = 'Sélectionnez quel groupe d\'utilisateurs utilisera ce profil. Notez que le fait de choisir un group déjà affecté par ailleurs le déliera du précédent profil. Si aucun profil n\'est rattaché à un groupe d\'utilisateurs, le profil par défaut sera chargé.';
$lang['id'] = 'ID&nbsp;';
$lang['image_advtab'] = 'Activer les options avancées pour les images (style, bordure, espacement)';
$lang['image_classes'] = 'Classes CSS pouvant être appliquées aux images';
$lang['image_classes_info'] = 'Une classe par ligne, exemple : <code><em>Image avec bordure=bordered border-round</em></code>';
$lang['image_plugin'] = 'Options du plugin Image';
$lang['info_linker_autocomplete'] = 'Commencez par taper quelques caractères du nom de la page ou de son alias. Tous les noms correspondants seront affichés dans une liste.';
$lang['install_profile_admin'] = 'Administrateurs';
$lang['install_profile_advanced'] = 'Avancé';
$lang['install_profile_frontend'] = 'Utilisateurs site';
$lang['install_profile_minimal'] = 'Minimal&nbsp;';
$lang['install_profile_standard'] = 'Standard&nbsp;';
$lang['js_template'] = 'Gabarit Javascript';
$lang['link_classes'] = 'Classes CSS pouvant être appliquées aux liens';
$lang['link_classes_info'] = 'Une classe par ligne, exemple : <code><em>Bouton bleu=btn btn-blue</em></code>';
$lang['loading_info'] = 'Chargement...';
$lang['menubar'] = 'Barre de menu';
$lang['name'] = 'Nom';
$lang['new_profile'] = 'Créer un nouveau profil';
$lang['newwindow'] = 'Nouvelle fenêtre';
$lang['no_design_linked'] = 'Aucun design';
$lang['none'] = 'Aucun';
$lang['orig_js_template_file'] = 'Gabarit original fourni avec le module';
$lang['plugins'] = 'Plugins&nbsp;';
$lang['postinstall'] = 'L\'éditeur TinyMCE a été installé avec succès. <strong>Important :</strong> si vous utilisez la réécriture d\'URL, vous devez mettre à jour votre fichier .htaccess (consultez la page d\'aide pour en savoir plus)';
$lang['priority'] = 'Priorité';
$lang['profile_copied'] = 'Le profil a été dupliqué avec succès';
$lang['profile_deleted'] = 'Le profil a été supprimé avec succès';
$lang['profile_name'] = 'Nom du profil';
$lang['profile_saved'] = 'Profil sauvé avec succès';
$lang['profiles'] = 'Profils';
$lang['prompt_linker'] = 'Entrez le titre de la page';
$lang['prompt_profiles'] = 'Profils';
$lang['prompt_selectedalias'] = 'Alias de page sélectionné';
$lang['prompt_name'] = 'Nom&nbsp;';
$lang['prompt_target'] = 'Cible';
$lang['prompt_class'] = 'Classe CSS';
$lang['prompt_rel'] = 'Attribut rel (type de relation)';
$lang['prompt_texttodisplay'] = 'Texte à afficher';
$lang['relative_urls'] = 'Générer des URLs relatives';
$lang['resize'] = 'Redimensionnement';
$lang['resize_no'] = 'Ne pas permettre le redimensionnement';
$lang['resize_vertical'] = 'Permettre le redimensionnement en hauteur';
$lang['resize_both'] = 'Permettre le redimensionnement en hauteur et largeur';
$lang['show_menubar'] = 'Afficher la barre de menu';
$lang['show_statusbar'] = 'Afficher la barre de statut';
$lang['show_toolbar'] = 'Afficher la barre d\'outils (îcones)';
$lang['style_formats'] = 'Formats de style';
$lang['style_formats_info'] = 'Une règle par ligne, exemple : <code><em>title: \'Titre rouge\', block: \'h2\', classes: \'text-red\'</em></code>';
$lang['subhelp_contextmenu_content'] = 'Syntaxe : <em>cmsms_linker link image | inserttable cell</em>';
$lang['subhelp_custom_block_formats'] = 'Syntaxe : <em>Paragraph=p;Header 1=h1;Header 2=h2</em>';
$lang['subhelp_toolbar'] = 'Syntaxe : <em>undo redo | cut copy paste | bold italic</em><br>Boutons spéciaux CMSMS : <em>customdropdown</em>, <em>cmsms_linker</em>, <em>responsivefilemanager</em>';
$lang['subhelp_custom_dropdown'] = 'Syntaxe : <em>Titre|contenu à insérer</em> ou <em>Titre|contenu au début|contenu à la fin</em> pour ajouter <em>contenu au début</em> avant la sélection, et <em>contenu à la fin</em> après.<br>N\'oubliez pas d\'ajouter le bouton <em><strong>customdropdown</strong></em> à votre barre d\'outils.';
$lang['submit'] = 'Valider';
$lang['tab_general_title'] = 'Général';
$lang['tab_advanced_title'] = 'Avancé';
$lang['template'] = 'Gabarit';
$lang['templates'] = 'Gabarits';
$lang['title_cmsms_linker'] = 'Créer un lien vers une page de contenu';
$lang['toolbar'] = 'Barre d\'outils';
$lang['toolbar1'] = 'Barre d\'outils - 1ère ligne';
$lang['toolbar2'] = 'Barre d\'outils - 2ème ligne';
$lang['tooltip_selectedalias'] = 'Ce champ est en lecture seul';
$lang['type_TinyMCE'] = 'TinyMCE&nbsp;';
$lang['type_js'] = '&nbsp;Javascript';
$lang['type_js_description'] = 'Script Javascript d\'initialisation de TinyMCE - La personnalisation de ce script vous offre un contrôle complet sur le lancement de l\'éditeur. Consultez la documentation de TinyMCE pour en savoir plus (https://www.tinymce.com/docs/)';
$lang['type_usertemplate'] = '&nbsp;Gabarit utilisateur TinyMCE';
$lang['type_usertemplate_description'] = 'Vous pouvez utiliser ce type de gabarit pour créer des blocs HTML que les utilisateurs de l\'éditeur TinyMCE pourront insérer dans leur contenu grâce au plugin <em>template</em>';
$lang['use_advanced_menu'] = 'Utiliser le menu avancé';
$lang['use_custom_block_formats'] = 'Utiliser une liste de formats personnalisée';
$lang['usergroups'] = 'Groupes utilisateurs';
$lang['help'] = '<h3>What Does This Do?</h3>
<p>
	This module embeds the full TinyMCE WYSIWYG editor version in CMS Made Simple. It works with content blocks in CMSMS content pages (when a WYSIWYG has been allowed), in module Admin forms where WYSIWYG editors are allowed, and allows restricted capabilities for editing html blocks on frontend pages.
</p>
<p>In order for TinyMCE to be used as the WYSIWYG editor in the Admin console the TinyMCE WYSIWYG Editor needs to be selected in the users preferences. Please select "TinyMCE" in the "Select WYSIWYG to Use" option under "My Preferences >> User Preferences" in the CMSMS Admin panel. Additional options in various modules or in content page templates, and content pages themselves can control whether a text area or a WYSIWYG field is provided in various edit forms.</p>
<p>For Frontend editing capabilities TinyMCE must be selected as the "Frontend WYSIWYG" in the global settings page of the CMSMS admin console.</p>

<h3>Features:</h3>
<ul>
	<li>Full native <a href="http://www.tinymce.com" target="_blank">TinyMCE editor</a> is available.</li>
	<li>Configuration profiles and backend groups attribution.</li>
	<li>Lots of customization options: toolbar, menubar, external modules, custom styles, ...</li>
	<li>Uses the internal page linker from the MicroTiny module.</li>
	<li>Embeds the powerful <a href="http://www.responsivefilemanager.com/" target="_blank">Responsive File Manager</a> thanks to its author Alberto Peripolli. Note: for security reasons, the Responsive File Manager will not be available to the frontend users</li>
	<li>Ability to use an external javascript template file from the DesignManager instead of the stock JS file - This permits a complete customization of the init script.</li>
	<li>Customizable appearance by specifying a design to use for the editor.</li>
</ul>

<h3>How do I use it</h3>
<ul>
	<li>Install and configure the module</li>
	<li><strong style="color: red">Important:</strong> if you\'re using URL Rewriting, you must update your .htaccess file and replace:
		<ul>
			<li><code>RedirectMatch 403 ^.*/modules/(.*)\\.php</code>$ with:</li>
			<li><code>RedirectMatch 403 ^.*/modules/(?!TinyMCE/responsive_filemanager/filemanager/).*\\.php$</code></li>
			<li>... in order to make the Responsive File Manager work - If you already did some changes on that line, please update the rule accordingly</li>
		</ul>
	</li>
	<li>Create and configure the appropriate profiles in <em>Extensions</em> / <em>TinyMCE WYSIWYG editor</em></li>
	<li>Don\'t forget to link profiles with backend user groups (or frontend) in the TinyMCE profile</li>
	<li>Set TinyMCE as your WYSIWYG editor of choice in "My Preferences"</li>
</ul>

<p>
	Note about profile edition: the backend user <strong>must have</strong> the <em>Manage TinyMCE profiles</em> permission to get the TinyMCE Admin page.
</p>

<h3>Caching:</h3>
<p>In an effort to improve performance, TinyMCE will attempt to cache the generated JavaScript files unless something has changed. Saving a profile or clearing the CMS Made Simple cache will always reset the JS cache file.</p>

<h3>Module developers: how to create a new button for your module in TinyMCE?</h3>
<p>
	You must add three functions to your main module class - Example for the Gallery module:
</p>

<code><pre>
	function HasCapability($capability, $params=array()) {
		if ($capability==\'WYSIWYGItems\') return true;
		return false;
	}

	function GetWYSIWYGBtnName()
	{
		return \'module_gallery\';
	}

	function GetWYSIWYGBtn($wysiwyg_module)
	{
		// TEST ARRAY EXAMPLE
		$items = array(
			array(
				\'menu_text\' => \'Gallery 1\',
				\'content\' => "{Gallery dir=\'dir1\'}", // Empty = no action on click
				\'children\' => array(
					array(
						\'menu_text\' => \'SubGallery 1.1\',
						\'content\' => "{Gallery dir=\'subdir11\'}"
						\'children\' => array() // You can have as many sublevels as you need
					),
					array(
						\'menu_text\' => \'SubGallery 1.2\',
						\'content\' => "{Gallery dir=\'subdir12\'}"
					),
					array(
						\'menu_text\' => \'SubGallery 1.3\',
						\'content\' => "{Gallery dir=\'subdir13\'}"
					)
				)
			),
			array(
				\'menu_text\' => \'Gallery 2\',
				\'content\' => "{Gallery dir=\'dir2\'}", // Empty = no action on click
				\'children\' => array(
					array(
						\'menu_text\' => \'SubGallery 2.1\',
						\'content\' => "{Gallery dir=\'subdir21\'}"
					),
					array(
						\'menu_text\' => \'SubGallery 2.2\',
						\'content\' => "{Gallery dir=\'subdir22\'}"
					),
					array(
						\'menu_text\' => \'SubGallery 2.3\',
						\'content\' => "{Gallery dir=\'subdir23\'}"
					)
				)
			)
		);

		// BUILD THE BUTTON OBJECT USED BY THE TinyMCE MODULE
		if ($wysiwyg_module == \'TinyMCE\')
		{
			$obj = new tinymce_modulemenu;
			$obj->module_name = $this->GetName();
			$obj->button_name = $this->GetWYSIWYGBtnName();
			$obj->title = $this->Lang(\'tinymce_button_picker\');
			$obj->tooltip = $this->Lang(\'tinymce_description_picker\');
			$obj->icon = \'image\';
			$obj->image = $this->GetModuleURLPath() . \'/images/icon.gif\';
			$obj->menu_entries = $items;
			$obj->menu_section = \'insert\';

			return $obj;
		}
		return false;
	}
</pre></code>

<p>
	The <strong>GetWYSIWYGBtn()</strong> function must return a <strong>tinymce_modulemenu</strong> object with an array <em>menu_entries</em> property.
</p>
<br>

<h3>License informations</h3>
<p>This module is free software - you can use it under the terms of the GNU General Public License 2 or any later version.</p>
<p><strong>However</strong>, the <a href="http://www.responsivefilemanager.com/" target="_blank">Responsive FileManager</a> is licensed under a <a href="http://creativecommons.org/licenses/by-nc/3.0/" target="_blank">Creative Commons Attribution-NonCommercial 3.0 Unported License</a>. The TinyMCE module includes it <strong>with the permission from Alberto Peripolli</strong> given on 2016-01-19. Thank you Alberto! <a href="http://www.responsivefilemanager.com/" target="_blank">If you want to support that project, please check this page and make a free donation.</a></p>

<h3>Help and support</h3>
<p>We tried to explain each configuration option on the profile edition Admin page. Please use the "?" buttons near each option to get more informations.</p>

<h3>Bug report or feature request</h3>
<p>
	Checkout the CMS Made Simple forge: <a href="http://dev.cmsmadesimple.org/projects/tinymce" target="_blank">http://dev.cmsmadesimple.org/projects/tinymce</a>
</p>

<h3>Authors</h3>
<ul>
	<li>Morten Poulsen: <a href="mailto:morten@poulsen.org">morten@poulsen.org</a></li>
	<li>Rolf Tjassens: <a href="mailto:rolf@cmsmadesimple.org">rolf@cmsmadesimple.org</a></li>
	<li>Mathieu Muths: <a href="mailto:contact@airelibre.net">contact@airelibre.net</a></li>
</ul>';
?>