<?php
if (!$gCms)
	exit();

if (!$this->CheckPermission('Use Gallery'))
{
	echo $this->ShowErrors(lang('needpermissionto', 'Use Gallery'));
	return;
}

if (!isset($params['gid']))
{
	$params['module_error'] = lang('missingparams');
	$this->Redirect($id, 'defaultadmin', '', $params);
	return;
}

$galleryinfo = Gallery_utils::Getgalleryinfobyid($params['gid']);
$gallerypath = $params['gid'] == 1 ? '' : trim($galleryinfo['filepath'] . '/' . $galleryinfo['filename'], '/');

$gallery = Gallery_utils::Getgalleryfiles($gallerypath);
foreach ($gallery as $file)
{
	if (substr($file['filename'], -1) != '/')
	{
		$thumbname = Gallery_utils::DefaultGalleryThumbPath() . $file['fileid'] . '-' . $params['templateid'] . substr($file['filename'], strrpos($file['filename'], '.'));

		Gallery_utils::CreateThumbnail($thumbname, Gallery_utils::DefaultGalleryPath() . (empty($file['filepath']) ? '' : $file['filepath'] . '/') . $file['filename'], $galleryinfo['thumbwidth'], $galleryinfo['thumbheight'], $galleryinfo['resizemethod']);
	}
}

$this->Redirect($id, 'editgallery', '', array('gid' => $params['gid'], 'mode' => "edit", 'module_message' => $this->Lang('thumbscreated')));
?>