{* Tabs Headers *}
<div id="page_tabs">
  <div id="general">
    General
  </div>    
  <div id="api">
    API
  </div>
  <div id="pear">
    PEAR Text / Captcha
  </div>
  <div id="i_recaptcha">
    Invisible reCaptcha
  </div>
  <div id="new">
    What's New
  </div>       
  <div id="credits">
    Credits
  </div>
</div>
{* Tabs Headers *}

<div class="clearb"></div>

{* Tabs Contents *}
<div id="page_content">

{*************************************************************************************}
{* General *}
  <div id="general_c">
    <h3>What Does This Do?</h3>
    <p>Enables captcha support for use in other modules.</p>
    <p>See <a href="http://www.wikipedia.org/wiki/Captcha">http://www.wikipedia.org/wiki/Captcha</a> for more information about Captcha challenge-response tests.</p>
    <p>
    <strong>Your PHP version must have GD installed with support for JPEGs and TrueType fonts for some of the libraries</strong>. For more information, see <a href="http://www.php.net/image/">PHP Image Functions</a>.<br />
    </p>
        
    <h3>Webserver permissions</h3>
    <p>
      When using libraries that generate images and store them on the server, the server process must have <strong><i>write</i></strong> access on the folder cache of CMS Madesimple (tmp/cache of your installation folder).<br />
    On some servers (depending on server settings) the umask in the CMS Made Simple Global Settings may have to be changed; try changing it from 022 to 002 if the captcha images are created but not shown.
    </p>
    <h3>How Do I Use It?</h3>
    <div class='warning'>If you use the reCaptcha library, please read the <b>What's New</b> tab for important information regarding <b>reCaptcha 2.0</b> use and the new <b>Invisble reCaptcha</b>.</div>
    <p>
    This module is not for use directly on a page, it is a tool to be used by other modules. If you are a module developer and want to use Captcha in your module check the API tab.
    </p>
    <hr />
    <p>
    Some implementation examples:<br />
    <a href="http://dev.cmsmadesimple.org/projects/frontendusers" target="_blank">FrontEndUsers</a><br />
    <a href="http://dev.cmsmadesimple.org/projects/formbuilder" target="_blank">Form Builder</a><br />
    <a href="hev.cmsmadesimple.org/projects/cgbetterforms" target="_blank">CGBetterForms</a><br />
    <a href="http://dev.cmsmadesimple.org/projects/questions" target="_blank">Questions</a>
    </p>
    
  </div>
{*************************************************************************************}
{* API *}
  <div id="api_c">
    <p>If you are a module developer and want to use Captcha in your module:</p>  
     <p>
        To show a captcha image:
        <pre style="display:block;">
        // create a reference to a Captcha module object
        $captcha = $this->getModuleInstance('Captcha'); 
        // show the captcha image
        echo $captcha->getCaptcha();
        </pre>
        To check the user input:
        <pre style="display:block;">
        // create a reference to a Captcha module object
        $captcha = $this->getModuleInstance('Captcha');
        
        // fallback if Captcha module is old
        $test = method_exists($captcha, 'NeedsInputField') ? $captcha->NeedsInputField() : true;
        
        // there is a method to deal with reCaptcha, and prevent showing an input when using it
        if($test) $smarty->assign( 'input_captcha',$this->CreateInputText($id, 'captcha_input','') );
        
        // check the user input (the checkCaptcha method will return TRUE if $input is correct, FALSE if $input is incorrect)
        // the next line will work regardless we have an input or not when using reCaptcha
        // reCaptcha will use it's own input whereas other libraries will use the module input
        $validated = $captcha->checkCaptcha($params['captcha_input]);
        
        </pre>
     </p> 
  </div>
{*************************************************************************************}
{* PEAR *}
  <div id="pear_c">
    <h3>PEAR Text/Captcha</h3>
        <p>
        This module can make use of PEAR&quot;s Text_CAPTCHA, which will have to be installed on the server.<br />
        Text_CAPTCHA depends on two other PEAR packages, Image_Text and Text_Password. It uses Text_Password to generate the random phrase used in the CAPTCHA test and Image_Text to generate an image file with text in it.<br />
        The process for installing Text_CAPTCHA at the command line is:<br />
        <pre>
        $ pear install Text_Password
        $ pear install Image_Text
        $ pear install --alldeps Text_CAPTCHA
        </pre>
        </p>
  </div>
{*************************************************************************************}
  {* Invisible reCaptcha *}
  <div id="i_recaptcha_c">
    <h3>Invisible reCaptcha</h3>
      <p>
        This module has the new Invisible reCaptcha library available. It brings some new features and options. However to be able to make full use of the extra features you'll need to be confortable with coding in javascript, with or without the use of frameworks.
      </p>
      <p>
        The new options are:
        <ul>
          <li><strong>badge:</strong> defines the position of the badge. Possible values are <strong>bottomright</strong>, <strong>bottomleft</strong> and <strong>inline</strong>;</li>
          <li><strong>theme:</strong> defines the theme of the badge. Possible values are <strong>light</strong> and <strong>dark</strong>;</li>
          <li><strong>error-callback:</strong> defines the name of the error-callback function in javascript. If left empty it falls back to the default reCaptcha behavior;</li>
        </ul>
    </p>
    <p>
        The new features are:
        <ul>
          <li>New options to set the <strong>badge</strong>, <strong>theme</strong> and <strong>error-callback</strong> (as described above);</li>
          <li>By defining a function name for the error-callback and implementing it you'll be able to change the reCaptcha default behaviour for errors, mainly network connectivity ones;</li>
          <li>The module implements, for this version of reCaptcha, a javascript event which is added to each form of the page: <strong>network connectivity</strong>. This event is called before the reCapcha execute call to allow the use of 3rd party validation libraries;</li>
        </ul>
    </p>

    <h3>Using error-callback</h3>
      <p>
        After setting the name of your callback function you'll need to implement the function on the page where the form is being used, either on a content block or on the main template. Keep in mind that reCaptcha is called as soon as the page is loaded and the if the function is not found reCaptcha might not work. Assuming you set <strong>myError</strong> as the function name youwill have to implement the following:
        <pre>
&lt;script>
    function myError() {
      alert('Network Connectivity Error! Please try again.'); // or whatever your want to use to handle the error
    }
&lt;/script></pre>
    </p>

    <h3>Validating Forms</h3>
      <p>
        If you are using HTML5 on browser validation, you shouldn't need to do anything at all. However if you want to use a 3rd party validation library you will probably need to add a listener to each form you want to validate. This Captcha plugin adds an event to each form where you use reCapcha. The event is called <strong>'validate'</strong>. To prevent the reCaptcha to run before validation, a possible implementation would be (the sample code uses the JQuery framework for simplification but the code should be easy to adapt to vanila javascript or any other framework):
        <pre>
&lt;script>
$( document ).ready()
{
  var forms = $('form:has(.recaptcha-holder)');// only forms with reCaptcha active

  forms.each(function(i)
  {
    this.holderId = i; // match the reCaptcha own holderId so that it ids which form is being handled
    this._submited = false; // prevent possible recursion

    $(this).on('validate', function(event)
    {
      event.preventDefault(); // prevent reCapcha execute

      if(!this._submited) // prevent recursion
      {
        this._submited = true; // there has been an attempt to submit the form so we flag it!
        /*
          here we implement our call to the validation library.
          we'll have to make sure that if the form is valid
          we then call
          grecaptcha.execute(this.holderId);
        */
        // pseudo code start
        // 'this' holds the form object
        var form_is_valid = myValidationLibray.validate(this); // adapt to yhe library used
        if(form_is_valid) // assuming that your library call returns a boolean value...
        {
          grecaptcha.execute(this.holderId);
        }
        // pseudo code end

        $(this).submit();
      }
    });
  });
};
&lt;/script></pre><br>
    This is just an example and not a <strong>copy & paste</strong>, ready to use snippet. Some validation libraries also implemt their own events so you may be able to use them instead of the if/then logic.
    </p>
  </div>
{*************************************************************************************}
{* NEW *}
  <div id="new_c">
    <h3>What's New</h3>
    <p>
      There is a new library for Invisble reCapcha, with some new options, please check the specific documentation.
    </p>
    <ul>
      <p>PLEASE NOTE:</p>
      <ul>
          <li>the reCaptcha V2 is not compatible with the previous 1.x releases;</li>
          <li>the secret keys used by the previous version of reCaptcha are not valid for reCaptcha 2.0, you need to get a pair expecific for reCaptcha V2;</li>
          <li>the secret keys have now different labels for reCaptcha 2.0: instead of <b><i>publickey</i></b> and <b><i>privatekey</i></b>, these are now <b><i>site key</i></b> and <b><i>secret</i></b>;</li>
        <li>Each different type of reCaptcha will need a pair expecific for it's type and version, meaning that in V2 keys from the <b>"I'm not a robot"</b> type won't work in <b>"Invisible reCaptcha"</b> type and vice versa;</li>
      </ul>

    </ul>
    <div class='information'>
      For more information on the new reCaptcha, please follow these links:
      <ul>
        <li><a href="https://www.google.com/recaptcha/intro/index.html" target="_blank">Introducing the new reCAPTCHA!</a>;</li>
        <li><a href="https://developers.google.com/recaptcha/intro" target="_blank">reCAPTCHA Developer's Guide</a>;</li>
      </ul>
    </div>
  </div>
{*************************************************************************************}  
{* NEW *}
  <div id="credits_c">
    <h3>Credits</h3>
    <p>Author and administrator of the original module until 2009: Dick Ittmann.</p>
    <p>Current Project Administrator and developerr: Fernando Morgado (Jo Morg).</p>
    <br />
    <p>This module has been released under the <a href="http://www.gnu.org/licenses/licenses.html#GPL" target="_blank">GNU Public License</a>. You must agree to this license before using the module.</p>
    <br />
    <p>Contributors:</p>
    <ul>
      <li>Robert Campbell (Calguy1000): numerous code contributions;</li>
      <li>Nuno Costa: code contributions;</li>
      <li>Jean-Claude Etiemble (jce76350): testing, suggestions and fixes;</li>
      <li>Rolf Tjassens (RolfTj): testing, suggestions and fixes;</li>
      <li>René Helminsen (reneh): testing;</li>
    </ul>
    <p>Sponsors:</p>
    <ul>
      <li><a href="https://www.matthornsby.ca" target="_blank">Matt Hornsby Production Graphics</a>;</li>
    </ul>


    <p>We apologize for any omissions - notify us, and we'll correct it!</p>
    <h3>Copyright and License</h3>
    <p>Copyright &copy; 2006 - 2013, Dick Ittmann. All Rights Reserved.</p>
    <p>Copyright &copy; 2014 - 2016, Mark Reed and Fernando Morgado. All Rights Reserved.</p>
    <p>Copyright &copy; 2017, Fernando Morgado. All Rights Reserved.</p>
  </div>
{*************************************************************************************}  
</div>
{* Tabs Contents end*}