<?php
/**
 * recaptcha
 * @see class.captchalib.php
 * @see CaptchaLib
 * @package Captcha
*/

/**
 * Needs class.captchalib.php
*/
require_once cms_join_path(dirname(dirname(__FILE__)), 'class.captchalib.php');

/**
 * @extends CaptchaLib
*/
class CaptchaLib_recaptcha extends CaptchaLib
{
  
  private $_reCaptcha;
  private $_hl;
	/**
	* Class constructor
	*/
	function CaptchaLib_recaptcha($cmsconfig)
	{
		// call the parent constructor
		$this->CaptchaLib('recaptcha', 'reCaptcha', $cmsconfig);
		$mod = cmsms()->GetModuleInstance('Captcha');
		$this->setPath('recaptcha-php');
		$this->setIncludeFiles(array('recaptchalib.php'));	
    
    $this->AddOption(new CaptchaLibOption('site_key' , 'string', ''));
    $this->AddOption(new CaptchaLibOption('secret' , 'string', ''));
	}
	
	function getCaptcha($options = array())
	{
		$this->load();
    $mod = cmsms()->GetModuleInstance('Captcha');
    if( !is_object($mod) ) return false;
    $hl_data_file = cms_join_path( 
                                    $mod->GetModulePath(),
                                    'data',
                                    'hl.data'
                                  );
    require($hl_data_file);
    
    if(empty($options['site_key'])) return false;
     $curlang = CmsNlsOperations::get_current_language();
     
     if( !in_array($curlang, $hl) )
     {
       if( strlen($curlang) == 2)
       {
         $curlang = 'en';
       }
       else
       {
         $curlang = substr($curlang, 0, 2);
         if( !in_array($curlang, $hl) ) $curlang = 'en';
       }
     }

    $html = '<div class="g-recaptcha" data-sitekey="' . $options['site_key'] . '"></div>
      <script type="text/javascript"
          src="https://www.google.com/recaptcha/api.js?hl=' . $curlang .'">
      </script>';
    
    return $html;
	}
	
	function checkCaptcha($input, $options = array()) 
	{
		$this->load();
    $mod = cmsms()->GetModuleInstance('Captcha');
    if(empty($options['secret'])) return false;

    $this->_reCaptcha = new ReCaptcha($options['secret']);
        
    if ($_POST["g-recaptcha-response"]) 
    {
        $resp = $this->_reCaptcha->verifyResponse(
                                                    $_SERVER["REMOTE_ADDR"],
                                                    $_POST["g-recaptcha-response"]
                                                  );
    }

        return $resp->success;
	}
	
}
?>
