<?php
#-------------------------------------------------------------------------
# Module: Captcha - Enables CAPTCHA support for use in other modules.
#-------------------------------------------------------------------------
# Version 1.0
# maintained by Fernando Morgado AKA Jo Morg since 2017
#-------------------------------------------------------------------------
# Original Author: Dick Ittmann
#-------------------------------------------------------------------------
#
# Captcha is a CMS Made Simple module that enables the web developer to create
# multiple lists throughout a site. It can be duplicated and given friendly
# names for easier client maintenance.
#
#-------------------------------------------------------------------------
# BEGIN_LICENSE
#-------------------------------------------------------------------------
#
# This file is part of Captcha
# Captcha program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Captcha program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
# END_LICENSE
#-------------------------------------------------------------------------
namespace Captcha;

/**
 * Class plugin_option
 *
 * This class implements a plugin options object.
 * It should have been originally called
 * something along the lines of "plugin_field_definition"
 * or something since the name "options" is misleading.
 * An options property has been added now to allow for
 * multi-options types of inputs.
 *
 * This class will have some new methods to make it
 * more flexible soon...
 *
 * @package Captcha
 */
class plugin_option
{
  /**
   * plugin option name
   * @var
   */
	var $name;
 
	/**
   * plugin option type
   * backward compatibility types:
   * - string;
   * - int;
   * - bool;
   * @var
   */
	var $type;
 
	/**
   * @var
   */
	var $default;
 
	/**
   * @var
   */
	var $options;
	
	function __construct( $name, $type, $default, $options = array() )
	{
		$this->setName($name);
		$this->setType($type);
		$this->setDefault($default);
		$this->setOptions($options);
	}
  
  /**
   * @param $name
   */
	function setName($name)
	{
		$this->name = $name;
	}
  
  /**
   * @return mixed
   */
	function getName()
	{
		return $this->name;
	}
  
  /**
   * @param $type
   */
	function setType($type)
	{
		$this->type = $type;
	}
  
  /**
   * @return mixed
   */
	function getType()
	{
		return $this->type;
	}
  
  /**
   * @param $value
   */
	function setDefault($value)
	{
		$this->default = $value;
	}
  
  /**
   * @return mixed
   */
	function getDefault()
	{
		return $this->default;
	}
  
  /**
   * @param array $options
   * @since
   */
	function setOptions( $options = array() )
	{
		$this->options = $options;
	}
  
  /**
   * @return mixed
   */
	function getOptions()
	{
		return $this->options;
	}
	
}

?>