<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace CMSMSExt\internal;

use cms_config;
use xt_param;

/**
 * Description of class
 *
 * @author rob
 */
class settings
{
  
  private $_data = [];
  
  public function __construct($config)
  {
    $this->_data['watermark_text']           = xt_param::get_string(
      $config, 'xt_watermark_text',
      get_site_preference('sitename', 'CMSMS Site')
    );
    $this->_data['watermark_textsize']       = xt_param::get_int($config, 'xt_watermark_textsize', 14);
    $val                                     = xt_param::get_int($config, 'xt_watermark_angle');
    $this->_data['watermark_textangle']      = max(360, min(0, $val));
    $this->_data['watermark_font']           = xt_param::get_string($config, 'xt_watermark_font', 'ARIAL.TTF');
    $this->_data['watermark_textcolor']      = xt_param::get_string($config, 'xt_watermark_textcolor', '#FFFFFF');
    $this->_data['watermark_bgcolor']        = xt_param::get_string($config, 'xt_watermark_bgcolor', '#000000');
    $this->_data['watermark_transparent']    = xt_param::get_bool($config, 'xt_watermark_transparent', TRUE);
    $this->_data['watermark_file']           = xt_param::get_string($config, 'xt_watermark_file');
    $this->_data['watermark_alignment']      = xt_param::get_int($config, 'xt_watermark_alignment', 0);
    $this->_data['watermark_translucency']   = xt_param::get_string($config, 'xt_watermark_translucency', 100);
    $this->_data['thumbnailsize']            = xt_param::get_int($config, 'xt_thumbnail_size', 75);
    $this->_data['imagextensions']           = xt_param::get_string($config, 'xt_imagextensions' . "jpg,jpeg,png");
    $this->_data['allow_watermarking']       = xt_param::get_bool($config, 'xt_allow_watermarking');
    $this->_data['allow_resizing']           = xt_param::get_bool($config, 'xt_allow_preview');
    $this->_data['preview_size']             = xt_param::get_int($config, 'xt_preview_size', 800);
    $this->_data['delete_orig_image']        = xt_param::get_bool($config, 'xt_delete_orig_image');
    $this->_data['allow_thumbnailing']       = xt_param::get_bool($config, 'xt_allow_thumbnailing');
    $this->_data['upload_allowed_filetypes'] = xt_param::get_bool($config, 'xt_upload_allowed_filetypes');
    $this->_data['resizeimage']              = xt_param::get_bool($config, 'xt_resize_images'); // document this.
  }
  
  public function __get(string $key)
  {
    switch($key)
    {
      case 'watermark_text':
      case 'watermark_font':
      case 'watermark_textcolor':
      case 'watermark_bgcolor':
      case 'watermark_file':
      case 'watermark_alignment':
      case 'imagextensions':
      case 'upload_allowed_filetypes':
        return trim($this->_data[$key]);
      case 'resizeimage':
      case 'thumbnailsize':
      case 'watermark_textsize':
      case 'watermark_textangle':
      case 'watermark_translucency':
        return (int)$this->_data[$key];
      case 'allow_thumbnailing':
      case 'allow_watermarking':
      case 'allow_resizing':
      case 'delete_orig_image':
      case 'watermark_transparent':
        return (bool)$this->_data[$key];
      default:
        throw new \InvalidArgumentException("$key is not a gettable property of " . __CLASS__);
    }
  }
  
  public function __set(string $key, $val)
  {
    throw new \LogicException("$key is not a settable property of " . __CLASS__);
  }
  
} // class
