<?php
/**
 * Helper class to migrate settings from CGExtentions to CMSMSExt
 * @package CMSMS
 * @version 1.0
 * @author Fernando Morgado aka Jo Morg
 */

namespace CMSMSExt;


class cge_migration_tools
{
  /**
   * private properties
   */
  
  /**
   * The instance
   *
   * @access private
   */
  private static $_instance;
  
  /**
   * @var null
   */
  private static $_cms_config           = NULL;
  
  /**
   * @var null
   */
  private static $_module_config        = NULL;
  
  /**
   * @var array
   */
  private static $_buffer = [];
  
  
  /**
   * private methods
   */
  
  /**
   * migration_tools constructor.
   */
  private function __construct(){ }
  
  private function _load_cms_config()
  {
    if( empty(self::$_cms_config) )
    {
      $root_path         = dirname(__FILE__, 4);
      $contents          = file_get_contents( cms_join_path($root_path, 'config.php') );
      $contents          = htmlentities($contents, ENT_NOQUOTES);
      $contents          = str_replace('"', "'", $contents);
      self::$_cms_config = explode("\n", $contents);
    }
  }
  
  private function _load_module_config()
  {
    if( empty( self::$_module_config) && $this->module_config_file_exists() )
    {
      $module_path = dirname(__FILE__, 2);
      $contents          = file_get_contents( cms_join_path($module_path, 'data', 'cfg.inc') );
      $contents          = htmlentities($contents, ENT_NOQUOTES);
      $contents          = str_replace('"', "'", $contents);
      self::$_module_config = explode("\n", $contents);
    }
  }
  
  private function _scan_for_cge_config_entries()
  {
    $found = FALSE;
    
    # clear buffer
    self::$_buffer = [];

    foreach(self::$_cms_config as $line)
    {
      if( \startswith($line, '$config[\'cge_') )
      {
        self::$_buffer[] = str_replace('$config[\'cge_', '$config[\'xt_', $line);
        $found = TRUE;
        continue;
      }
      
      if( \startswith($line, '$config[\'cgjs_') )
      {
        self::$_buffer[] = str_replace('$config[\'cgjs_', '$config[\'xtjs_', $line);
        $found = TRUE;
        continue;
      }
      
      # since we are looking for an occurrence of '_adminsection' make sure it's not a commented out line
      if(
        strpos($line, '_adminsection') !== false
        &&
        !( \startswith($line, '\\\\') || \startswith($line, '#')  )
      )
      {
        self::$_buffer[] = $line;
        $found = TRUE;
        continue;
      }
    }
    
    return $found;
  }
  
  
  /**
   * private methods
   */
  
  /**
   * GetInstance method used to access the object
   *
   * @access public
   * @return
   */
  public static function GetInstance()
  {
    if(!isset(self::$_instance))
    {
      self::$_instance  = new self;
    }
    
    return self::$_instance;
  }
  
  public function module_config_file_exists()
  {
    $module_path = dirname(__FILE__, 2);
    $file = cms_join_path($module_path, 'data', 'cfg.inc');
    return file_exists($file);
  }
  
  
  public function migrate_config_entries()
  {
    $this->_load_cms_config();
    
    if($this->_scan_for_cge_config_entries() )
    {
      self::$_module_config = [];
  
      if( $this->module_config_file_exists() )
      {
        $this->_load_module_config();
        
        # remove &lt;?php and ?&gt; (php file start and ending tags)
        $tmp = self::$_module_config;
        self::$_module_config = [];
        
        foreach($tmp as $line)
        {
          if(
            strpos($line, '&lt;?php') !== false ||
            strpos($line, '?&gt;') !== false
          )
          {
            continue;
          }
          
          self::$_module_config[] = $line;
        }
      }
      
      foreach(self::$_buffer as $line)
      {
        self::$_module_config[] = $line;
      }
      
      self::$_module_config = array_unique(self::$_module_config);
      
      # put back the PHP tags
      array_unshift(self::$_module_config, '&lt;?php');
      self::$_module_config[] = '?&gt;';
  
  
      $contents = html_entity_decode( implode("\n", self::$_module_config) );
      $module_path = dirname(__FILE__, 2);
      $filename = cms_join_path($module_path, 'data', 'cfg.inc');
      file_put_contents($filename, $contents);
    }
    
  }
  
}
?>