<?php

namespace CMSMSExt;

if(version_compare(CMS_VERSION, '2.2.900') < 0)
{
  abstract class _tmpResourceBase extends \CMS_Fixed_Resource_Custom
  {
  }
}
else
{
  abstract class _tmpResourceBase extends \CMSMS\internal\fixed_smarty_custom_resource
  {
  }
}

/**
 * Class FileTemplateResource
 *
 * looks for files ONLY in the modules paths.  Ignores module_custom
 * if no files exist in the modules paths tries finding them in CMSMSExt/framework/templates
 *
 * @uses {include file='xt_modfile:ModuleName;TemplateName.tpl'} in templates or
 *        $smarty->fetch('xt_modfile:' . $this->GetName() . ';' . TemplateName.tpl);
 *
 * @package CMSMSExt
 */
class FileTemplateResource extends _tmpResourceBase
{
  protected function fetch($name, &$source, &$mtime)
  {
    $name        = (string)$name;
    $module_name = $tpl_name = NULL;
    $parts       = explode(';', $name);
    
    if(count($parts) < 2) { return; }
    
    $module_name = trim($parts[0]);
    $tpl_name    = trim($parts[1]);
    
    if(!$module_name || !$tpl_name) { return; }

    $mod = \cms_utils::get_module($module_name);
    
    if(!$mod) { return; }
  
    $filename = \cms_join_path(
      $mod->GetModulePath(),
      'templates',
      $tpl_name
    );
    
    if( !is_file($filename) )
    {
      $mod = \cms_utils::get_module('CMSMSExt');
      $filename = \cms_join_path(
        $mod->GetModulePath(),
        'framework',
        'templates',
        $tpl_name
      );
    }
  
    $source = file_get_contents($filename);
    $mtime  = filemtime($filename);
  }
} // end of class
