<?php

//declare(strict_types=1);# revisit
namespace CMSMSExt;
use CMSMS\HookManager;
use CmsRegularTask;
use cms_siteprefs;

class DailyHookTask implements CmsRegularTask
{
    public function get_name() { return get_class(); }
    public function get_description() {}

    public function test($time = '')
    {
        if( !$time ) $time = time();
        $lastrun = (int) cms_siteprefs::get(__CLASS__);
        if( $time - $lastrun > 24 * 3600 ) return true;
        return false;
    }

    public function execute($time = '')
    {
        if( !$time ) $time = time();
        HookManager::do_hook('CMSMSExt::DailyTask', $time);
        return true;
    }

    public function on_success($time = '')
    {
        if( !$time ) $time = time();
        cms_siteprefs::set(__CLASS__,$time);
    }

    public function on_failure($time = '')
    {
        if( !$time ) $time = time();
    }

} // class
