<?php
if( !isset($gCms) ) exit;

// download an image... or a file, or dump an image to stdout
// just with obfuscation so that the filename and path are not obvious.
$params = \xt_utils::decrypt_params( $params );
$file = \xt_param::get_string( $params, 'file' );
$dl = \xt_param::get_bool( $params, 'download' );
$nocache = \xt_param::get_bool( $params, 'nocache' );
if( $file && is_file( $file ) ) {
    $mime_type = \xt_utils::get_mime_type( $file );
    if( ! startswith( $mime_type, 'image/') ) $dl = true;
    if( $dl ) \xt_utils::send_file_and_exit( $file );

    if( $nocache ) {
        header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
        header('Cache-Control: private',false);
    }
    header('Content-type: '.$mime_type);
    header('Content-Length: ' . filesize($file));

    $chunksize = 65535;
    $handle=fopen($file,'rb');
    $contents = '';
    do {
        $data = fread($handle,$chunksize);
        if( strlen($data) == 0 ) break;
        print($data);
    } while(true);
    fclose($handle);
}
exit();