/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.gui.image;

import java.awt.Canvas;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.filedata.PictureFileData;
import wjhk.jupload2.policies.UploadPolicy;

public class PicturePanel
extends Canvas
implements MouseListener,
ComponentListener {
    private static final long serialVersionUID = -3439340009940699981L;
    private PictureFileData pictureFileData;
    private Image offscreenImage = null;
    private boolean hasToStoreOffscreenPicture = false;
    protected UploadPolicy uploadPolicy;

    public PicturePanel(boolean hasToStoreOffscreenPicture, UploadPolicy uploadPolicy) {
        this.hasToStoreOffscreenPicture = hasToStoreOffscreenPicture;
        this.uploadPolicy = uploadPolicy;
        this.addMouseListener(this);
        this.addComponentListener(this);
    }

    public void setPictureFile(PictureFileData pictureFileData, AbstractButton button1, AbstractButton button2) {
        this.pictureFileData = null;
        if (this.offscreenImage != null) {
            this.offscreenImage.flush();
            this.offscreenImage = null;
        }
        this.repaint();
        boolean enableButton = false;
        if (pictureFileData != null && pictureFileData.canRead()) {
            this.pictureFileData = pictureFileData;
            enableButton = true;
            this.calculateOffscreenImage();
            this.repaint();
        }
        if (button1 != null) {
            button1.setEnabled(enableButton);
        }
        if (button2 != null) {
            button2.setEnabled(enableButton);
        }
    }

    public void paint(Graphics g) {
        g.clearRect(0, 0, this.getWidth(), this.getHeight());
        if (this.offscreenImage != null) {
            int hMargin = (this.getWidth() - this.offscreenImage.getWidth(this)) / 2;
            int vMargin = (this.getHeight() - this.offscreenImage.getHeight(this)) / 2;
            g.drawImage(this.offscreenImage, hMargin, vMargin, this);
            this.offscreenImage.flush();
        }
    }

    public void rotate(int quarter) {
        if (this.pictureFileData != null) {
            Cursor previousCursor = this.uploadPolicy.setWaitCursor();
            this.pictureFileData.addRotation(quarter);
            this.offscreenImage.flush();
            this.offscreenImage = null;
            this.calculateOffscreenImage();
            this.repaint();
            this.uploadPolicy.setCursor(previousCursor);
        } else {
            this.uploadPolicy.displayWarn("Hum, this is really strange: there is no pictureFileData in the PicturePanel! Command is ignored.");
        }
    }

    private void calculateOffscreenImage() {
        if (this.pictureFileData == null) {
            if (this.offscreenImage != null) {
                this.offscreenImage = null;
                this.uploadPolicy.displayWarn("PicturePanel.calculateOffscreenImage(): pictureFileData is null (offscreenImage set to null");
            }
        } else if (this.offscreenImage == null) {
            this.uploadPolicy.displayDebug("PicturePanel.calculateOffscreenImage(): trying to calculate offscreenImage (PicturePanel.calculateOffscreenImage()", 30);
            try {
                this.offscreenImage = this.pictureFileData.getImage(this, this.hasToStoreOffscreenPicture);
            }
            catch (JUploadException e) {
                this.uploadPolicy.displayErr(e);
                this.pictureFileData = null;
                this.offscreenImage = null;
            }
        }
    }

    protected void finalize() throws Throwable {
        this.uploadPolicy.displayDebug("Within PicturePanel.finalize()", 10);
        if (this.offscreenImage != null) {
            this.offscreenImage.flush();
        }
    }

    public void mouseClicked(MouseEvent arg0) {
        if (this.pictureFileData != null) {
            this.uploadPolicy.onFileDoubleClicked(this.pictureFileData);
        }
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent arg0) {
    }

    public void mouseReleased(MouseEvent arg0) {
    }

    public void componentHidden(ComponentEvent arg0) {
    }

    public void componentMoved(ComponentEvent arg0) {
    }

    public void componentResized(ComponentEvent arg0) {
        if (this.offscreenImage != null) {
            this.offscreenImage.flush();
            this.offscreenImage = null;
        }
        this.calculateOffscreenImage();
        this.repaint();
    }

    public void componentShown(ComponentEvent arg0) {
    }
}

