/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.gui;

import java.awt.Frame;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.TransferHandler;
import wjhk.jupload2.gui.DnDListener;
import wjhk.jupload2.gui.JUploadDebugPopupMenu;
import wjhk.jupload2.gui.JUploadFileChooser;
import wjhk.jupload2.gui.JUploadMainPopupMenu;
import wjhk.jupload2.gui.JUploadPanel;
import wjhk.jupload2.gui.JUploadTextArea;
import wjhk.jupload2.gui.JUploadTransferHandler;
import wjhk.jupload2.gui.filepanel.FilePanel;
import wjhk.jupload2.gui.filepanel.FilePanelTableImp;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.upload.FileUploadManagerThread;
import wjhk.jupload2.upload.FileUploadManagerThreadImpl;

public class JUploadPanelImpl
extends JPanel
implements ActionListener,
JUploadPanel,
MouseListener {
    private static final long serialVersionUID = -1212601012568225757L;
    private JUploadDebugPopupMenu jUploadDebugPopupMenu;
    private JUploadMainPopupMenu jUploadMainPopupMenu;
    private DnDListener dndListener = null;
    private JButton browseButton = null;
    private JButton removeButton = null;
    private JButton removeAllButton = null;
    private JButton uploadButton = null;
    private JButton stopButton = null;
    private JUploadFileChooser fileChooser = null;
    private FilePanel filePanel = null;
    private JProgressBar preparationProgressBar = null;
    private JProgressBar uploadProgressBar = null;
    private JLabel statusLabel = null;
    private JUploadTextArea logWindow = null;
    private JScrollPane jLogWindowPane = null;
    private UploadPolicy uploadPolicy = null;
    private FileUploadManagerThread fileUploadManagerThread = null;

    public JUploadPanelImpl(JUploadTextArea logWindow, UploadPolicy uploadPolicyParam) throws Exception {
        this.logWindow = logWindow;
        this.uploadPolicy = uploadPolicyParam;
        this.jUploadDebugPopupMenu = new JUploadDebugPopupMenu(this.uploadPolicy);
        this.jUploadMainPopupMenu = new JUploadMainPopupMenu(this.uploadPolicy, this);
        this.createStandardComponents();
        logWindow.addMouseListener(this);
        this.dndListener = new DnDListener(this, this.uploadPolicy);
        new DropTarget(this, this.dndListener);
        new DropTarget(this.filePanel.getDropComponent(), this.dndListener);
        new DropTarget(this.logWindow, this.dndListener);
        JUploadTransferHandler jUploadTransfertHandler = new JUploadTransferHandler(this.uploadPolicy, this);
        this.setTransferHandler(jUploadTransfertHandler);
        this.filePanel.setTransferHandler(jUploadTransfertHandler);
        ActionMap map = this.getActionMap();
        map.put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
        this.browseButton.addMouseListener(this);
        this.removeAllButton.addMouseListener(this);
        this.removeButton.addMouseListener(this);
        this.stopButton.addMouseListener(this);
        this.uploadButton.addMouseListener(this);
        this.jLogWindowPane.addMouseListener(this);
        logWindow.addMouseListener(this);
        this.preparationProgressBar.addMouseListener(this);
        this.uploadProgressBar.addMouseListener(this);
        this.statusLabel.addMouseListener(this);
        this.uploadPolicy.addComponentsToJUploadPanel(this);
    }

    private void createStandardComponents() {
        if (this.browseButton == null) {
            this.browseButton = new JButton(this.uploadPolicy.getLocalizedString("buttonBrowse", new Object[0]));
            this.browseButton.setIcon(new ImageIcon(this.getClass().getResource("/images/explorer.gif")));
        }
        this.browseButton.addActionListener(this);
        if (this.removeButton == null) {
            this.removeButton = new JButton(this.uploadPolicy.getLocalizedString("buttonRemoveSelected", new Object[0]));
            this.removeButton.setIcon(new ImageIcon(this.getClass().getResource("/images/recycle.gif")));
        }
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(this);
        if (this.removeAllButton == null) {
            this.removeAllButton = new JButton(this.uploadPolicy.getLocalizedString("buttonRemoveAll", new Object[0]));
            this.removeAllButton.setIcon(new ImageIcon(this.getClass().getResource("/images/cross.gif")));
        }
        this.removeAllButton.setEnabled(false);
        this.removeAllButton.addActionListener(this);
        if (null == this.uploadButton) {
            this.uploadButton = new JButton(this.uploadPolicy.getLocalizedString("buttonUpload", new Object[0]));
            this.uploadButton.setIcon(new ImageIcon(this.getClass().getResource("/images/up.gif")));
        }
        this.uploadButton.setEnabled(false);
        this.uploadButton.addActionListener(this);
        this.filePanel = new FilePanelTableImp(this, this.uploadPolicy);
        if (null == this.preparationProgressBar) {
            this.preparationProgressBar = new JProgressBar(0);
            this.preparationProgressBar.setStringPainted(true);
        }
        if (null == this.uploadProgressBar) {
            this.uploadProgressBar = new JProgressBar(0);
            this.uploadProgressBar.setStringPainted(true);
        }
        if (null == this.stopButton) {
            this.stopButton = new JButton(this.uploadPolicy.getLocalizedString("buttonStop", new Object[0]));
            this.stopButton.setIcon(new ImageIcon(this.getClass().getResource("/images/cross.gif")));
        }
        this.stopButton.setEnabled(false);
        this.stopButton.addActionListener(this);
        if (this.jLogWindowPane == null) {
            this.jLogWindowPane = new JScrollPane();
            this.jLogWindowPane.setVerticalScrollBarPolicy(22);
            this.jLogWindowPane.setHorizontalScrollBarPolicy(31);
        }
        this.jLogWindowPane.getViewport().add(this.logWindow);
        this.jLogWindowPane.setPreferredSize(null);
        this.statusLabel = new JLabel("JUpload applet " + this.uploadPolicy.getContext().getDetailedVersionMessage());
    }

    public void showOrHideLogWindow() {
        if (this.uploadPolicy.getShowLogWindow().equals("true") || this.uploadPolicy.getShowLogWindow().equals("onError") && this.uploadPolicy.getLastException() != null) {
            this.jLogWindowPane.setVisible(true);
        } else {
            this.jLogWindowPane.setVisible(false);
        }
        this.validate();
    }

    public void doBrowse() {
        if (null == this.fileChooser) {
            try {
                this.uploadPolicy.displayDebug("Before this.uploadPolicy.createFileChooser()", 80);
                this.fileChooser = this.uploadPolicy.createFileChooser();
                this.uploadPolicy.displayDebug("After this.uploadPolicy.createFileChooser()", 80);
            }
            catch (Exception e) {
                this.uploadPolicy.displayErr(e);
            }
        }
        if (null != this.fileChooser) {
            try {
                int ret = this.fileChooser.showOpenDialog(new Frame());
                if (0 == ret) {
                    this.filePanel.addFiles(this.fileChooser.getSelectedFiles(), this.fileChooser.getCurrentDirectory());
                }
                this.uploadPolicy.setCurrentBrowsingDirectory(this.fileChooser.getCurrentDirectory().getAbsolutePath());
                this.fileChooser.shutdownNow();
            }
            catch (Exception ex) {
                this.uploadPolicy.displayErr(ex);
            }
        }
    }

    public void doRemove() {
        this.filePanel.removeSelected();
        if (0 >= this.filePanel.getFilesLength()) {
            this.removeButton.setEnabled(false);
            this.removeAllButton.setEnabled(false);
            this.uploadButton.setEnabled(false);
        }
    }

    public void doRemoveAll() {
        this.filePanel.removeAll();
        this.removeButton.setEnabled(false);
        this.removeAllButton.setEnabled(false);
        this.uploadButton.setEnabled(false);
    }

    public void doStartUpload() {
        try {
            if (this.uploadPolicy.beforeUpload() && this.getFilePanel().getFilesLength() > 0) {
                this.fileUploadManagerThread = new FileUploadManagerThreadImpl(this.uploadPolicy);
                this.fileUploadManagerThread.start();
            }
        }
        catch (Exception e) {
            this.uploadPolicy.displayErr(e.getClass().getName() + " in JUploadPanelImpl.doStartUpload()", e);
        }
    }

    public void doStopUpload() {
        this.fileUploadManagerThread.stopUpload();
    }

    public void actionPerformed(ActionEvent e) {
        this.uploadPolicy.displayDebug("Action : " + e.getActionCommand(), 1);
        String actionPaste = (String)TransferHandler.getPasteAction().getValue("Name");
        if (e.getActionCommand().equals(actionPaste)) {
            Action a = this.getActionMap().get(actionPaste);
            if (a != null) {
                a.actionPerformed(new ActionEvent(this.filePanel, 1001, e.getActionCommand()));
                this.uploadPolicy.afterFileDropped(new DropTargetDropEvent(new DropTarget(this.filePanel.getDropComponent(), this.dndListener).getDropTargetContext(), new Point(), 2, 3));
            }
        } else if (e.getActionCommand() == this.browseButton.getActionCommand()) {
            this.doBrowse();
        } else if (e.getActionCommand() == this.removeButton.getActionCommand()) {
            this.doRemove();
        } else if (e.getActionCommand() == this.removeAllButton.getActionCommand()) {
            this.doRemoveAll();
        } else if (e.getActionCommand() == this.uploadButton.getActionCommand()) {
            this.doStartUpload();
        } else if (e.getActionCommand() == this.stopButton.getActionCommand()) {
            this.doStopUpload();
        }
        this.filePanel.focusTable();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.maybeOpenPopupMenu(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.maybeOpenPopupMenu(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.maybeOpenPopupMenu(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.maybeOpenPopupMenu(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.uploadPolicy.onFileDoubleClicked(this.filePanel.getFileDataAt(mouseEvent.getPoint()));
        } else {
            this.maybeOpenPopupMenu(mouseEvent);
        }
    }

    public boolean maybeOpenPopupMenu(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            if ((mouseEvent.getModifiersEx() & 0x80) == 128) {
                if (this.jUploadDebugPopupMenu != null) {
                    this.jUploadDebugPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    return true;
                }
            } else if (this.jUploadMainPopupMenu != null) {
                this.jUploadMainPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                return true;
            }
        }
        return false;
    }

    public void updateButtonState() {
        if (this.fileUploadManagerThread != null && this.fileUploadManagerThread.isAlive() && !this.fileUploadManagerThread.isUploadFinished()) {
            this.browseButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.removeAllButton.setEnabled(false);
            this.uploadButton.setEnabled(false);
            this.stopButton.setEnabled(true);
            this.uploadPolicy.updateButtonState(2);
        } else {
            this.browseButton.setEnabled(true);
            this.stopButton.setEnabled(false);
            boolean enabled = this.filePanel.getFilesLength() > 0;
            this.removeButton.setEnabled(enabled);
            this.removeAllButton.setEnabled(enabled);
            this.uploadButton.setEnabled(enabled);
            this.uploadPolicy.updateButtonState(1);
        }
    }

    public void clearLogWindow() {
        this.logWindow.setText("");
    }

    public void copyLogWindow() {
        this.logWindow.copyLogWindow();
    }

    public ActionListener getActionListener() {
        return this;
    }

    public JButton getBrowseButton() {
        return this.browseButton;
    }

    public JComponent getJComponent() {
        return this;
    }

    public DnDListener getDndListener() {
        return this.dndListener;
    }

    public FilePanel getFilePanel() {
        return this.filePanel;
    }

    public JScrollPane getJLogWindowPane() {
        return this.jLogWindowPane;
    }

    protected JUploadTextArea getLogWindow() {
        return this.logWindow;
    }

    public MouseListener getMouseListener() {
        return this;
    }

    public JProgressBar getPreparationProgressBar() {
        return this.preparationProgressBar;
    }

    public JProgressBar getUploadProgressBar() {
        return this.uploadProgressBar;
    }

    public JButton getRemoveAllButton() {
        return this.removeAllButton;
    }

    public JButton getRemoveButton() {
        return this.removeButton;
    }

    public JLabel getStatusLabel() {
        return this.statusLabel;
    }

    public JButton getStopButton() {
        return this.stopButton;
    }

    public JButton getUploadButton() {
        return this.uploadButton;
    }

    public void setFilePanel(FilePanel filePanel) {
        this.filePanel = filePanel;
    }

    public FileUploadManagerThread getFileUploadManagerThread() {
        return this.fileUploadManagerThread;
    }
}

