/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.gui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import wjhk.jupload2.filedata.DefaultFileData;
import wjhk.jupload2.gui.JUploadPanel;
import wjhk.jupload2.policies.UploadPolicy;

public class DnDListener
implements DropTargetListener {
    private JUploadPanel uploadPanel;
    private UploadPolicy uploadPolicy;
    DataFlavor uriListFlavor = new DataFlavor("text/uri-list;class=java.lang.String", null);

    public DnDListener(JUploadPanel uploadPanel, UploadPolicy uploadPolicy) {
        this.uploadPanel = uploadPanel;
        this.uploadPolicy = uploadPolicy;
    }

    public void dragEnter(DropTargetDragEvent e) {
        if (!e.isDataFlavorSupported(DataFlavor.javaFileListFlavor) && !e.isDataFlavorSupported(this.uriListFlavor)) {
            e.rejectDrag();
        }
    }

    public void dragOver(DropTargetDragEvent e) {
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    public void drop(DropTargetDropEvent e) {
        if (!e.isDataFlavorSupported(DataFlavor.javaFileListFlavor) && !e.isDataFlavorSupported(this.uriListFlavor)) {
            e.rejectDrop();
        } else {
            e.acceptDrop(3);
            try {
                File[] fileArray;
                if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    List fileList = (List)e.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    fileArray = (File[])fileList.toArray();
                } else {
                    String strList = (String)e.getTransferable().getTransferData(this.uriListFlavor);
                    ArrayList<File> fileList = new ArrayList<File>();
                    for (String s : strList.split("\n")) {
                        try {
                            fileList.add(new File(new URI(s.trim())));
                        }
                        catch (URISyntaxException ex) {
                            ex.printStackTrace();
                            e.rejectDrop();
                            return;
                        }
                    }
                    fileArray = fileList.toArray(new File[fileList.size()]);
                }
                this.uploadPanel.getFilePanel().addFiles(fileArray, DefaultFileData.getRoot(fileArray));
                e.getDropTargetContext().dropComplete(true);
                this.uploadPolicy.afterFileDropped(e);
            }
            catch (IOException ioe) {
                this.uploadPolicy.displayErr("DnDListener.drop()", ioe);
                e.rejectDrop();
            }
            catch (UnsupportedFlavorException ufe) {
                this.uploadPolicy.displayErr("DnDListener.drop()", ufe);
                e.rejectDrop();
            }
        }
    }

    public void dragExit(DropTargetEvent e) {
    }
}

